'  ****  LOG PERIODIC DIPOLE ARRAY (LPDA) DESIGN SOFTWARE  ****

'  ****  INPUT DESIGN DATA & CALCULATE FORMULAS FROM THE ARRL ANTENNA HANDBOOK ****

10 CLS : CLEAR
11 PRINT "                Log-Periodic Dipole Array (LPDA) Design Software"
12 PRINT "                            by James Watterson, KB0RJG"
13 PRINT
20 INPUT "High Frequency of Interest "; Fh: PRINT
30 INPUT "Low Frequency of Interest "; Fl: PRINT
40 B = Fh / Fl
50 INPUT "Choose Tau from Fig 2 (0.8 < TAU < 0.98) "; TAU: PRINT
52 OptSigma = TAU * .227 - .03773
54 PRINT "Choose Sigma from Fig 2 (0.05 < SIGMA -- Optimum SIGMA = ";
56 PRINT ; USING "#.###) "; OptSigma;
60 INPUT ; SIGMA
62 PRINT : PRINT
70 ALPHA = (4 * SIGMA) / (1 - TAU)
80 Bar = 1.1 + 7.7 * ((1 - TAU) ^ 2) * ALPHA
90 Bs = Bar * B
100 BOOMft = (.25 * (1 - (1 / Bs))) * ALPHA * (984 / Fl)
110 N = 1 + (LOG(Bs) / LOG(1 / TAU)): IF N - FIX(N) > .299 THEN N = FIX(N) + 1 ELSE N = FIX(N)
120 DIM LENGTHS(N)
130 l1 = 492 / Fl: LENGTHS(0) = l1
140 Zt = (984 / Fl) / 8
150 FOR X = 1 TO N - 1
160 LENGTHS(X) = TAU * LENGTHS(X - 1)
170 NEXT X
180 DIM DISTANCES(N)
190 DISTANCES(0) = .5 * (LENGTHS(0) - LENGTHS(1)) * ALPHA
200 FOR X = 1 TO N - 1
210 DISTANCES(X) = TAU * DISTANCES(X - 1)
220 NEXT X
230 Zt = 984 / Fl * .125
240 DIM DIAMS(N), LtoDRatio(N)

'  ****  LOOP THROUGH THE CALCULATED NUMBER OF ELEMENTS AND INPUT DIAMETERS  ****

300 INPUT "Enter the Choice of Diameter for the Shortest Element from Table 1 "; DIAMS(N): PRINT
310 INPUT "Will All Elements be this Same Diameter ([Y]/N)"; AN$
320 LtoDRatio(N) = (LENGTHS(N - 1) * 12) / DIAMS(N)
330 SIGMAPRIME = SIGMA / SQR(TAU)
340 IF AN$ = "n" OR AN$ = "N" THEN GOTO 360
350 IF AN$ = "Y" OR AN$ = "y" OR AN$ = "" THEN FOR X = 1 TO N: DIAMS(X) = DIAMS(N): NEXT X: GOTO 400
360 FOR X = N - 1 TO 1 STEP -1
370 PRINT "Enter the Choice of the Diameter of Element"; X: INPUT ""; DIAMS(X)
380 NEXT X

'  ****  ENTER FEEDPOINT IMPEDANCE AND CONDUCTOR SIZE  ****

400 PRINT : INPUT "Enter the Choice of Feedpoint Impedance "; R0: PRINT
410 Zav = 120 * (LOG(LtoDRatio(N)) - 2.25)
420 Z0 = ((R0 ^ 2) / (8 * SIGMAPRIME * Zav)) + (R0 * (SQR((((R0 / (8 * SIGMAPRIME * Zav)) ^ 2) + 1))))
430 INPUT "Enter the Outer Diameter of the Conductor of Choice "; CONDUCTOR: PRINT
440 S = (CONDUCTOR / 2) * (10 ^ (Z0 / 276))
450 DEFSNG A-Z
'  ****  PRINT OUT RESULTS TO THE SCREEN  ****

500 CLS :
520 COLOR 4: PRINT "Lowest Frequency"; Fl; "MHz": PRINT
525 PRINT "Highest Frequency"; Fh; "MHz": PRINT
530 COLOR 7: PRINT "Operating Bandwidth"; B: PRINT
540 COLOR 4: PRINT "Design Constant (Tau)"; TAU: PRINT
545 PRINT "Relative Spacing Constant (Sigma)"; SIGMA: PRINT
550 COLOR 7: PRINT "Co-Tangent of Alpha"; ALPHA: PRINT
560 PRINT "Bandwidth of the Active Region"; Bar: PRINT
565 PRINT "Bandwidth of the Structure"; Bs: PRINT
570 COLOR 4: PRINT "Boom Length"; BOOMft; "Feet": PRINT
575 PRINT "Total Number of Elements"; N: PRINT
580 PRINT "Distance of Stub (Boom Addition) Behind Longest Element"; Zt; "Inches": PRINT
582 PRINT : COLOR 7
584 INPUT "Next Page ([Y]/N)"; AN$: IF AN$ = "N" OR AN$ = "n" THEN 860
586 IF AN$ = "Y" OR AN$ = "y" OR AN$ = "" THEN 590 ELSE 584

' ****  DISPLAY SECOND PORTION  ****

590 CLS : PRINT "Choice of Input Resistance (Pre-Balun)"; R0; "Ohms": PRINT
600 PRINT "Average Characteristic Impedance of a Dipole "; Zav; "Ohms": PRINT
610 PRINT "Mean Spacing Factor"; (SIGMAPRIME * 1); "Inches": PRINT
620 PRINT "Characteristic Impedance of the Antenna Feeder"; Z0; "Ohms": PRINT

'  ****  PREPARE TO DISPLAY NEXT PAGE  ****

670 PRINT
680 INPUT "Next Page ([Y]/N)"; AN$: IF AN$ = "N" OR AN$ = "n" THEN 860
690 IF AN$ = "Y" OR AN$ = "y" OR AN$ = "" THEN 695 ELSE 680
695 CLS : PRINT "Element #       Inches      Centimeters   Frequency      Diameter": PRINT
700 FOR X = 0 TO (N - 1)
710 FREQ = 492 / LENGTHS(X): DIAMETER = (LENGTHS(X) * 12) / 149.94
720 PRINT (X + 1), LENGTHS(X) * 12, (LENGTHS(X) * 12) * 2.54, FREQ, DIAMETER
725 IF X = 15 THEN 2000
730 NEXT X
740 PRINT : PRINT : INPUT "Next Page ([Y]/N)"; AN$
742 IF AN$ = "N" OR AN$ = "n" THEN 860
745 IF AN$ = "Y" OR AN$ = "y" OR AN$ = "" THEN CLS : LOCATE 1, 31: PRINT "Inches      Centimeters      Feet": PRINT : GOTO 750
747 GOTO 740
750 FOR X = 0 TO (N - 2)
760 PRINT "Spacing Between "; X + 1; "&"; X + 2, DISTANCES(X) * 12; , (DISTANCES(X) * 12) * 25.4, DISTANCES(X)
765 IF X = 20 THEN GOTO 2500
770 NEXT X
780 PRINT : INPUT "Next Page ([Y]/N)"; AN$: IF AN$ = "N" OR AN$ = "n" THEN 860
785 IF AN$ = "Y" OR AN$ = "y" OR AN$ = "" THEN CLS : GOTO 790
786 GOTO 780
790 FOR X = 1 TO N
800 PRINT "Diameter for Element"; X; " "; DIAMS(X); "Inches"
810 PRINT "Length-to-Diameter Ratio for Element"; X; " "; LENGTHS(X - 1) * 12 / DIAMS(X)
820 PRINT
825 IF X = 7 OR X = 14 OR X = 21 OR X = 28 OR X = 35 OR X = 42 OR X = 49 OR X = 56 THEN GOTO 2700
830 NEXT X
840 PRINT : INPUT "Would You Like a Hardcopy of this Data ([Y]/N)"; COPY$
850 IF COPY$ = "Y" OR COPY$ = "y" OR COPY$ = "" THEN GOSUB 900 ELSE 860
860 CLS : PRINT : PRINT : PRINT : INPUT "Would You Like to Recalculate an LPDA ([Y]/N)"; AN$
880 IF AN$ = "Y" OR AN$ = "y" OR AN$ = "" THEN 10 ELSE 890
890 CLS : END

'  ****  PRINT OUT THE HARDCOPY  ****

900 CLS : LOCATE 3, 15: PRINT "Printing Hardcopy"
910 LPRINT "           DESIGN PARAMETERS FOR AN LPDA COVERING"; Fl; "MHz TO"; Fh; "MHz": LPRINT
915 LPRINT : LPRINT "                         SECTION 1 - GENERAL DESIGN STATISTICS": FOR G = 1 TO 4: LPRINT : NEXT G
920 LPRINT "Lowest Operating Frequency"; Fl: LPRINT
930 LPRINT "Highest Operating Frequency"; Fh: LPRINT
940 LPRINT "Operating Bandwidth"; B: LPRINT
950 LPRINT "Design Constant (Tau)"; TAU: LPRINT
960 LPRINT "Relative Spacing Constant (Sigma)"; SIGMA: LPRINT
970 LPRINT "Co-Tangent of Alpha"; ALPHA: LPRINT
980 LPRINT "Bandwidth of the Active Region"; Bar: LPRINT
990 LPRINT "Bandwidth for the Structure"; Bs: LPRINT
1000 LPRINT "Boom Length"; BOOMft; "Feet": LPRINT
1010 LPRINT "Total Number of Elements"; N: LPRINT
1020 LPRINT "Distance of Stub (Boom Addition) Behind Longest Element"; Zt; "Inches": LPRINT
1030 LPRINT "Choice of Input Resistance (Pre-Balun)"; R0; "Ohms": LPRINT
1040 LPRINT "Average Characteristic Impedance of a Dipole"; Zav; "Ohms": LPRINT
1050 LPRINT "Mean Spacing Factor"; (SIGMAPRIME * 1): LPRINT
1060 LPRINT "Characteristic Impedance of the Antenna Feeder"; Z0; "Ohms": LPRINT
1070 LPRINT CHR$(12), CHR$(32), CHR$(32)
1075 LPRINT "            SECTION 2 - ELEMENT LENGTHS AND RESONANT FREQUENCIES": FOR G = 1 TO 3: LPRINT : NEXT G
1078 LPRINT "Element #       Inches      Centimeters   Frequency      Diameter": LPRINT
1080 FOR X = 0 TO (N - 1)
1090 FREQ = 492 / LENGTHS(X): DIAMETER = (LENGTHS(X) * 12) / 149.94
1100 LPRINT (X + 1), LENGTHS(X) * 12, (LENGTHS(X) * 12) * 2.54, FREQ, DIAMETER
1110 NEXT X
1120 REM **** ADD PAGE LENGTH CHECK ****
1125 LPRINT CHR$(12), CHR$(32), CHR$(32)
1127 LPRINT "                       SECTION 3 - ELEMENT SPACINGS": FOR G = 1 TO 3: LPRINT : NEXT G
1129 LPRINT "                              Inches      Millimeters      Feet": LPRINT
1130 FOR X = 0 TO (N - 2)
1140 LPRINT "Spacing Between"; X + 1; "&"; X + 2, DISTANCES(X) * 12, (DISTANCES(X) * 12) * 25.4, DISTANCES(X)
1150 NEXT X
1160 REM **** ADD PAGE LENGTH CHECK ****
1165 LPRINT CHR$(12), CHR$(32), CHR$(32)
1169 LPRINT "          SECTION 4 - ELEMENT DIAMETERS AND LENGTH-TO-DIAMETER RATIOS": FOR G = 1 TO 3: LPRINT : NEXT G
1170 FOR X = 1 TO N
1180 LPRINT "Diameter for Element"; X; " "; DIAMS(X); "Inches"
1190 LPRINT "Length-to-Diameter Ratio for Element"; X; " "; LENGTHS(X - 1) * 12 / DIAMS(X)
1200 LPRINT
1205 IF X = 19 OR X = 38 OR X = 57 THEN LPRINT CHR$(12), CHR$(32), CHR$(32)
1210 NEXT X
1220 RETURN
 
' **** PAGE LENGTH CHECK SUBROUTINE ****

2000 PRINT : INPUT "Next Page ([Y]/N)"; AN$
2010 IF AN$ = "N" OR AN$ = "n" THEN 860
2020 IF AN$ = "Y" OR AN$ = "y" OR AN$ = "" THEN CLS : PRINT "Element #       Inches      Centimeters   Frequency      Diameter": PRINT : GOTO 730
2030 GOTO 2000

' **** PAGE LENGTH CHECK SUBROUTINE 2 ****

2500 PRINT : INPUT "Next Page ([Y]/N)"; AN$
2510 IF AN$ = "N" OR AN$ = "n" THEN 860
2520 IF AN$ = "Y" OR AN$ = "y" OR AN$ = "" THEN CLS : LOCATE 1, 31: PRINT "Inches      Centimeters      Feet": PRINT : GOTO 770
2530 GOTO 2500

' **** PAGE LENGTH CHECK SUBROUTINE 3 ****

2700 PRINT : INPUT "Next Page ([Y]/N)"; AN$
2710 IF AN$ = "N" OR AN$ = "n" THEN 860
2720 IF AN$ = "Y" OR AN$ = "y" OR AN$ = "" THEN CLS : GOTO 830
2730 GOTO 2700

